Attribute VB_Name = "mdUseComponent"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function UseComponent(component As aDesignInstance, materialStatus, bHideComponent As Boolean, featureName)

'Convenience Function to use a specified component as a feature modeling tool

'Get the ProDESKTOP Application Object
GetApplicationObject

'Get the Active Part Document
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Continue only if Part is available
If Part Is Nothing Then
   Set UseComponent = Nothing
   Exit Function
End If

'hide the component if the value of bHideComponent is true
If bHideComponent Then
    component.SetHidden (True)
    Part.ClearSelection
End If

Dim op As aTool
'perform operation to a create tool
Set op = app.GetClass("Tool").CreateTool(Part.GetDesign, component, materialStatus)
op.SetName featureName
Part.UpdateDesign

Set UseComponent = op

End Function
